var DynamicClientSideScriptHandler = (function () {
    // Fetch the script link from div tags
    function checkDivTags(identifier){
        var divTag = document.querySelector('div[data-identifier="' + identifier + '"]');
        if(!divTag) return null;
        return divTag.getAttribute("data-content");
    }

    // Fetch the script link from meta tags
    function checkMetaTags(identifier){
        var metaTag = document.querySelector('meta[name="' + identifier + '"]');
        if(!metaTag) return null;
        return metaTag.getAttribute("content");
    }

    // Fetch the script link from div or meta tags
    function fetchScriptLink(identifier){
        var scriptLink = null;
        scriptLink = checkDivTags(identifier);
        if(scriptLink === null){
            scriptLink = checkMetaTags(identifier);
        }
        return scriptLink;
    }

    return {
        // Public function to fetch the link of a previously registered AEM client library.
        // identifier: The identifier used to register the AEM client library using the
        //             /apps/cascade.component.authoring/dynamicclientsidelibs/registerClientLib.html template
        // Usage: DynamicClientSideScriptHandler.fetchScriptLink("myIdentifier");
        fetchScriptLink: fetchScriptLink
    }
})();